/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.sam.tableUtils;

import com.quantumdata.sam.tableUtils.AttributiveCellRenderer;
import com.quantumdata.sam.tableUtils.AttributiveCellTableModel;
import com.quantumdata.sam.tableUtils.ICellSpan;
import com.quantumdata.sam.tableUtils.MultiSpanCellTableUI;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Enumeration;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.TableColumn;

public class MultiSpanCellTable
extends JTable {
    private static final long serialVersionUID = 1L;

    public MultiSpanCellTable() {
        this.setUI(new MultiSpanCellTableUI());
        this.setDefaultRenderer(Object.class, new AttributiveCellRenderer());
    }

    public Rectangle getCellRect(int n, int n2, boolean bl) {
        int n3;
        Rectangle rectangle = super.getCellRect(n, n2, bl);
        if (n < 0 || n2 < 0 || this.getRowCount() <= n || this.getColumnCount() <= n2) {
            return rectangle;
        }
        AttributiveCellTableModel attributiveCellTableModel = (AttributiveCellTableModel)this.getModel();
        ICellSpan iCellSpan = (ICellSpan)((Object)attributiveCellTableModel.getCellAttribute());
        if (!iCellSpan.isVisible(n, n2)) {
            int n4 = n;
            n3 = n2;
            n += iCellSpan.getSpan(n4, n3)[0];
            n2 += iCellSpan.getSpan(n4, n3)[1];
        }
        int[] nArray = iCellSpan.getSpan(n, n2);
        n3 = 0;
        int n5 = this.getColumnModel().getColumnMargin();
        Rectangle rectangle2 = new Rectangle();
        int n6 = this.rowHeight + this.rowMargin;
        rectangle2.y = n * n6;
        rectangle2.height = nArray[0] * n6;
        Enumeration<TableColumn> enumeration = this.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            rectangle2.width = tableColumn.getWidth() + n5;
            if (n3 == n2) break;
            rectangle2.x += rectangle2.width;
            ++n3;
        }
        for (int i = 0; i < nArray[1] - 1; ++i) {
            TableColumn tableColumn = enumeration.nextElement();
            rectangle2.width += tableColumn.getWidth() + n5;
        }
        if (!bl) {
            Dimension dimension = this.getIntercellSpacing();
            rectangle2.setBounds(rectangle2.x + dimension.width / 2, rectangle2.y + dimension.height / 2, rectangle2.width - dimension.width, rectangle2.height - dimension.height);
        }
        return rectangle2;
    }

    private int[] rowColumnAtPoint(Point point) {
        int[] nArray = new int[]{-1, -1};
        int n = point.y / (this.rowHeight + this.rowMargin);
        if (n < 0 || this.getRowCount() <= n) {
            return nArray;
        }
        int n2 = this.getColumnModel().getColumnIndexAtX(point.x);
        ICellSpan iCellSpan = (ICellSpan)((Object)((AttributiveCellTableModel)this.getModel()).getCellAttribute());
        if (iCellSpan.isVisible(n, n2)) {
            nArray[1] = n2;
            nArray[0] = n;
            return nArray;
        }
        nArray[1] = n2 + iCellSpan.getSpan(n, n2)[1];
        nArray[0] = n + iCellSpan.getSpan(n, n2)[0];
        return nArray;
    }

    public int rowAtPoint(Point point) {
        return this.rowColumnAtPoint(point)[0];
    }

    public int columnAtPoint(Point point) {
        return this.rowColumnAtPoint(point)[1];
    }

    public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
        this.repaint();
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int n;
        int n2 = listSelectionEvent.getFirstIndex();
        int n3 = listSelectionEvent.getLastIndex();
        if (n2 == -1 && n3 == -1) {
            this.repaint();
        }
        Rectangle rectangle = this.getCellRect(n2, 0, false);
        int n4 = this.getColumnCount();
        int n5 = n2;
        for (n = 0; n < n4; ++n) {
            rectangle.add(this.getCellRect(n5, n, false));
        }
        n5 = n3;
        for (n = 0; n < n4; ++n) {
            rectangle.add(this.getCellRect(n5, n, false));
        }
        this.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }
}

